package examples.messaging.dd;

import javax.jms.Session;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.naming.InitialContext;

public class LogClient {

    public static void main(String[] args) throws Exception {
        InitialContext ctx = new InitialContext(System.getProperties());

        Topic topic = (Topic) ctx.lookup("jms/Topic");        
        TopicConnectionFactory factory = 
            (TopicConnectionFactory) ctx
                .lookup("jms/TopicConnectionFactory");
        TopicConnection connection = factory.createTopicConnection();
        TopicSession session = connection.createTopicSession(false,
                Session.AUTO_ACKNOWLEDGE);
        
        TopicPublisher publisher = session.createPublisher(topic);

        // create and publish a message
        TextMessage msg = session.createTextMessage();
        msg.setText("This is a test message.");
        publisher.publish(msg);

        System.out.println("Message published. Please check application server's console to see the response from MDB.");
    }
}